package nemosofts.voxradio.activity;

import android.content.Intent;
import android.net.Uri;
import android.os.Bundle;
import android.view.View;
import android.widget.ImageView;
import android.widget.ProgressBar;

import androidx.nemosofts.AppCompat;
import androidx.nemosofts.AppCompatActivity;

import com.squareup.picasso.Picasso;

import nemosofts.voxradio.R;
import nemosofts.voxradio.callback.Callback;

public class CustomAdsActivity extends AppCompatActivity {

    private ProgressBar pb;

    @Override
    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);

        pb = findViewById(R.id.pb_ads);
        ImageView iv_ads = findViewById(R.id.iv_ads);

        try {
            Picasso.get()
                    .load(Callback.custom_ads_img)
                    .into(iv_ads, new com.squareup.picasso.Callback() {
                        @Override
                        public void onSuccess() {
                            pb.setVisibility(View.GONE);
                        }

                        @Override
                        public void onError(Exception e) {
                            pb.setVisibility(View.GONE);
                        }
                    });
        } catch (Exception e) {
            e.printStackTrace();
        }

        iv_ads.setOnClickListener(view -> {
            String url = Callback.custom_ads_link;
            if (!url.startsWith("http://") && !url.startsWith("https://")){
                url = "http://" + url;
            }
            Intent browserIntent = new Intent(Intent.ACTION_VIEW, Uri.parse(url));
            startActivity(browserIntent);
        });

        findViewById(R.id.iv_ads_close).setOnClickListener(view -> onBackPressed());
    }

    @Override
    public int setLayoutResourceId() {
        return R.layout.activity_custom_ads;
    }

    @Override
    public int setAppCompat() {
        return AppCompat.COMPAT();
    }
}